function test_suite = testPower %#ok<STOUT>
initTestSuite;

function testZeroToZeroPower %#ok<*DEFNU>
% This behavior is consistent with that of MATLAB numbers (0.^0 = 1).
x = polysym(0);
z = x.^0;
assertTrue(isone(z));

function testZeroToFirstPower
x = polysym(0);
z = x.^1;
assertTrue(iszero(z))

function testZeroToSecondPower
x = polysym(0);
z = x.^2;
assertTrue(iszero(z))

function testOneToPowerGreaterThanOne
x = polysym(1);
z = x.^2;
assertTrue(isone(z))

function testZeroToPolysymPower
% Only accepts integer for power.
x = polysym(0);
f = @() x.^polysym('y');
assertExceptionThrown(f,'MATLAB:power:invalidType')

function testZeroToRealPower
x = polysym(0);
f = @() x.^pi;
assertExceptionThrown(f,'MATLAB:power:expectedInteger')

function testRealtoZeroPower
r = rand;
y = polysym(r);
z = y.^0;
assertTrue(isone(z));

function testChartoZeroPower
% This behavior is consistent with that of MATLAB numbers (0.^0 = 1).
x = polysym('x');
z = x.^0;
assertTrue(isone(z));

function testCharMpowerNonzeroInteger
x = polysym('x');
z = x.^5;
assertEqual(z.Value,'x^5');

function testCharToPowerOne
x = polysym('x');
z = x.^1;
assertEqual(x.Value,z.Value)

function testRealToPowerOne
r = rand;
x = polysym(r);
z = x.^1;
assertEqual(x.Value,z.Value)

function testScalarMpowerVector
x = polysym('x');
z = x.^(0:2);
assertEqual(z(1).Value,'1')
assertEqual(z(2).Value,'x')
assertEqual(z(3).Value,'x^2')

function testMatrixMpowerZero
% Gives the identity matrix
x = polysym({'x','y';'u','w'});
y = x.^0;
assertTrue(isone(y(1)))
assertTrue(isone(y(2)))
assertTrue(isone(y(3)))
assertTrue(isone(y(4)))

function testMpowerOfRowVector
x = polysym({'x','y'});
z =x.^2;
assertEqual(z(1).Value,'x^2')
assertEqual(z(2).Value,'y^2')

function testMpowerOfColumnVector
x = polysym({'x','y'}');
z = x.^2;
assertEqual(z(1).Value,'x^2')
assertEqual(z(2).Value,'y^2')

function testMatrixMpowerOne
x = polysym({'x','y';'u','w'});
z = x.^2;
assertEqual(z(1).Value,'x^2')
assertEqual(z(2).Value,'u^2')
assertEqual(z(3).Value,'y^2')
assertEqual(z(4).Value,'w^2')